/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book;

import io.github.fabricators_of_create.porting_lib.util.client.ScreenUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4f;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.BookScreen;

public class TextDataRenderer {
    @Deprecated
    public static String drawText(class_332 guiGraphics, int x, int y, int boxWidth, int boxHeight, TextData[] data, int mouseX, int mouseY, class_327 fr, BookScreen parent) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        String action = TextDataRenderer.drawText(guiGraphics, x, y, boxWidth, boxHeight, data, mouseX, mouseY, fr, tooltip);
        if (tooltip.size() > 0) {
            guiGraphics.method_51437(fr, tooltip, Optional.empty(), mouseX, mouseY);
        }
        return action;
    }

    public static String drawText(class_332 guiGraphics, int x, int y, int boxWidth, int boxHeight, TextData[] data, int mouseX, int mouseY, class_327 fr, List<class_2561> tooltip) {
        String action = "";
        int atX = x;
        int atY = y;
        float prevScale = 1.0f;
        for (TextData item : data) {
            boolean mouseInside;
            int box1W = 9999;
            Objects.requireNonNull(fr);
            int box1H = y + 9;
            int box2Y = 9999;
            int box3X = 9999;
            int box3Y = 9999;
            if (item == null || item.text == null || item.text.isEmpty()) continue;
            if (item.text.equals("\n")) {
                atX = x;
                Objects.requireNonNull(fr);
                atY += 9;
                continue;
            }
            if (item.paragraph) {
                atX = x;
                float f = atY;
                Objects.requireNonNull(fr);
                atY = (int)(f + (float)(9 * 2) * prevScale);
            }
            prevScale = item.scale;
            Object modifiers = "";
            if (item.useOldColor) {
                class_124 colFormat = class_124.method_533((String)item.color);
                if (colFormat != null) {
                    modifiers = (String)modifiers + colFormat;
                } else {
                    modifiers = (String)modifiers + "unknown color";
                    Mantle.logger.error("Failed to parse color: " + item.color + " for text rendering.");
                }
            }
            if (item.bold) {
                modifiers = (String)modifiers + class_124.field_1067;
            }
            if (item.italic) {
                modifiers = (String)modifiers + class_124.field_1056;
            }
            if (item.underlined) {
                modifiers = (String)modifiers + class_124.field_1073;
            }
            if (item.strikethrough) {
                modifiers = (String)modifiers + class_124.field_1055;
            }
            if (item.obfuscated) {
                modifiers = (String)modifiers + class_124.field_1051;
            }
            String text = TextDataRenderer.translateString(item.text);
            String[] split = TextDataRenderer.cropStringBySize(text, (String)modifiers, boxWidth, boxHeight - (atY - y), boxWidth - (atX - x), fr, item.scale);
            int box1X = atX;
            int box1Y = atY;
            int box2X = x;
            int box2W = x + boxWidth;
            for (int i = 0; i < split.length; ++i) {
                if (i == split.length - 1) {
                    box3X = atX;
                    box3Y = atY;
                }
                String s = split[i];
                TextDataRenderer.drawScaledString(guiGraphics, fr, (String)modifiers + s, atX, atY, item.rgbColor, item.dropshadow, item.scale);
                if (i < split.length - 1) {
                    Objects.requireNonNull(fr);
                    atY += 9;
                    atX = x;
                }
                if (i != 0) continue;
                box2Y = atY;
                box1W = atX == x ? x + boxWidth : atX;
            }
            int box2H = atY;
            if ((atX = (int)((float)atX + (float)fr.method_1727(split[split.length - 1]) * item.scale)) - x >= boxWidth) {
                atX = x;
                float f = atY;
                Objects.requireNonNull(fr);
                atY = (int)(f + 9.0f * item.scale);
            }
            int box3W = atX;
            float f = atY;
            Objects.requireNonNull(fr);
            int box3H = (int)(f + 9.0f * item.scale);
            boolean bl = mouseInside = mouseX >= box1X && mouseX <= box1W && mouseY >= box1Y && mouseY <= box1H && box1X != box1W && box1Y != box1H || mouseX >= box2X && mouseX <= box2W && mouseY >= box2Y && mouseY <= box2H && box2X != box2W && box2Y != box2H || mouseX >= box3X && mouseX <= box3W && mouseY >= box3Y && mouseY <= box3H && box3X != box3W && box1Y != box3H;
            if (item.tooltip != null && item.tooltip.length > 0) {
                if (BookScreen.debug) {
                    Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
                    ScreenUtils.drawGradientRect((Matrix4f)matrix, (int)0, (int)box1X, (int)box1Y, (int)box1W, (int)box1H, (int)-16711936, (int)-16711936);
                    ScreenUtils.drawGradientRect((Matrix4f)matrix, (int)0, (int)box2X, (int)box2Y, (int)box2W, (int)box2H, (int)-65536, (int)-65536);
                    ScreenUtils.drawGradientRect((Matrix4f)matrix, (int)0, (int)box3X, (int)box3Y, (int)box3W, (int)box3H, (int)-16776961, (int)-16776961);
                    ScreenUtils.drawGradientRect((Matrix4f)matrix, (int)0, (int)mouseX, (int)mouseY, (int)(mouseX + 5), (int)(mouseY + 5), (int)-65281, (int)-256);
                }
                if (mouseInside) {
                    tooltip.addAll(Arrays.asList(item.tooltip));
                }
            }
            if (item.action != null && !item.action.isEmpty() && mouseInside) {
                action = item.action;
            }
            if (atY >= y + boxHeight) {
                guiGraphics.method_51433(fr, "...", atX, atY, 0, item.dropshadow);
                break;
            }
            y = atY;
        }
        if (BookScreen.debug && !action.isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43473());
            tooltip.add((class_2561)class_2561.method_43470((String)("Action: " + action)).method_27692(class_124.field_1080));
        }
        return action;
    }

    public static String translateString(String s) {
        s = s.replace("$$(", "$\u0000(").replace(")$$", ")\u0000$");
        while (s.contains("$(") && s.contains(")$") && s.indexOf("$(") < s.indexOf(")$")) {
            String loc = s.substring(s.indexOf("$(") + 2, s.indexOf(")$"));
            s = s.replace("$(" + loc + ")$", class_1074.method_4662((String)loc, (Object[])new Object[0]));
        }
        if (s.indexOf("$(") > s.indexOf(")$") || s.contains(")$")) {
            Mantle.logger.error("[Books] [TextDataRenderer] Detected unbalanced localization symbols \"$(\" and \")$\" in string: \"" + s + "\".");
        }
        return s.replace("$\u0000(", "$(").replace(")\u0000$", ")$");
    }

    public static String[] cropStringBySize(String s, String modifiers, int width, int height, class_327 fr, float scale) {
        return TextDataRenderer.cropStringBySize(s, modifiers, width, height, width, fr, scale);
    }

    public static String[] cropStringBySize(String s, String modifiers, int width, int height, int firstWidth, class_327 fr, float scale) {
        int curWidth = 0;
        Objects.requireNonNull(fr);
        int curHeight = (int)(9.0f * scale);
        for (int i = 0; i < ((String)s).length(); ++i) {
            curWidth = (int)((float)curWidth + (float)fr.method_1727(modifiers + ((String)s).charAt(i)) * scale);
            if (((String)s).charAt(i) != '\n') {
                Objects.requireNonNull(fr);
                if (!(curHeight == (int)(9.0f * scale) ? curWidth > firstWidth : curWidth > width)) continue;
            }
            int oldI = i;
            if (((String)s).charAt(i) != '\n') {
                while (i >= 0 && ((String)s).charAt(i) != ' ') {
                    --i;
                }
                if (i <= 0) {
                    i = oldI;
                }
            } else {
                ++oldI;
            }
            s = ((String)s).substring(0, i) + "\r" + StringUtils.stripStart((String)((String)s).substring(i + (i == oldI ? 0 : 1)), (String)" ");
            ++i;
            curWidth = 0;
            float f = curHeight;
            Objects.requireNonNull(fr);
            curHeight = (int)(f + 9.0f * scale);
            if (curHeight < height) continue;
            return ((String)s).substring(0, i).split("\r");
        }
        return ((String)s).split("\r");
    }

    public static int getLinesForString(String s, String modifiers, int width, String prefix, class_327 fr) {
        return TextDataRenderer.cropStringBySize(s, modifiers, width, Short.MAX_VALUE, width - fr.method_1727(prefix), fr, 1.0f).length;
    }

    public static void drawScaledString(class_332 guiGraphics, class_327 font, String text, float x, float y, int color, boolean dropShadow, float scale) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(x, y, 0.0f);
        guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
        if (dropShadow) {
            guiGraphics.method_25303(font, text, 0, 0, color);
        } else {
            guiGraphics.method_51433(font, text, 0, 0, color, false);
        }
        guiGraphics.method_51448().method_22909();
    }
}

